// FilePlayerDlg.cpp : implementation file
//

#include "stdafx.h"
#include "FilePlayer.h"
#include "FilePlayerDlg.h"
#include <math.h>
#include <iostream>
#include <fstream>
using namespace std;

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CAboutDlg dialog used for App About

VOID SC_DEBUG( TCHAR * fmt, ... )
{
	TCHAR pszDebugDumpMessage[ 256 ] = "[QC] ";

	va_list marker;

	va_start( marker, fmt );

	vsprintf( pszDebugDumpMessage + 5, fmt, marker );

	va_end( marker );

	strcat( pszDebugDumpMessage, "\n" );

	OutputDebugString( pszDebugDumpMessage );
}

class CAboutDlg : public CDialog
{
public:
	CAboutDlg();

// Dialog Data
	//{{AFX_DATA(CAboutDlg)
	enum { IDD = IDD_ABOUTBOX };
	//}}AFX_DATA

	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CAboutDlg)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	//}}AFX_VIRTUAL

// Implementation
protected:
	//{{AFX_MSG(CAboutDlg)
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

CAboutDlg::CAboutDlg() : CDialog(CAboutDlg::IDD)
{
	//{{AFX_DATA_INIT(CAboutDlg)
	//}}AFX_DATA_INIT
}

void CAboutDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CAboutDlg)
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CAboutDlg, CDialog)
	//{{AFX_MSG_MAP(CAboutDlg)
		// No message handlers
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CFilePlayerDlg dialog

CFilePlayerDlg::CFilePlayerDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CFilePlayerDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CFilePlayerDlg)
		// NOTE: the ClassWizard will add member initialization here
	//}}AFX_DATA_INIT
	// Note that LoadIcon does not require a subsequent DestroyIcon in Win32
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
}

void CFilePlayerDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CFilePlayerDlg)
	DDX_Control(pDX, IDC_PROGRESS_AUDIO_VOLUME_DB_R, m_progAudioVolumeDBBar_R);
	DDX_Control(pDX, IDC_PROGRESS_AUDIO_VOLUME_DB_L, m_progAudioVolumeDBBar_L);
	DDX_Control(pDX, IDC_PROGRESS_TIME, m_progTimeBar);
	DDX_Control(pDX, IDC_STATIC_WINDOW, m_statWindow);
	DDX_Control(pDX, IDC_EDIT_FILE_PATH, m_editFilePath);
	//}}AFX_DATA_MAP
	DDX_Control(pDX, IDC_SLIDER_AUDIO_VOLUME, m_Audio_Volume);
	DDX_Control(pDX, IDC_STATIC_FRAME1, m_FrameWindow1);
	DDX_Control(pDX, IDC_STATIC_FRAME2, m_FrameWindow2);
	DDX_Control(pDX, IDC_STATIC_FRAME3, m_FrameWindow3);
	DDX_Control(pDX, IDC_STATIC_FRAME4, m_FrameWindow4);
	DDX_Control(pDX, IDC_STATIC_FRAME5, m_FrameWindow5);
	DDX_Control(pDX, IDC_STATIC_FRAME6, m_FrameWindow6);
	DDX_Control(pDX, IDC_STATIC_FRAME7, m_FrameWindow7);
	DDX_Control(pDX, IDC_STATIC_FRAME8, m_FrameWindow8);
	DDX_Control(pDX, IDC_STATIC_FRAME9, m_FrameWindow9);
	DDX_Control(pDX, IDC_STATIC_FRAME10, m_FrameWindow10);
	DDX_Control(pDX, IDC_STATIC_FRAME11, m_FrameWindow11);
	DDX_Control(pDX, IDC_STATIC_FRAME12, m_FrameWindow12);
	DDX_Control(pDX, IDC_STATIC_FRAME13, m_FrameWindow13);
	DDX_Control(pDX, IDC_STATIC_FRAME14, m_FrameWindow14);
	DDX_Control(pDX, IDC_STATIC_FRAME15, m_FrameWindow15);
	DDX_Control(pDX, IDC_STATIC_FRAME16, m_FrameWindow16);
}

BEGIN_MESSAGE_MAP(CFilePlayerDlg, CDialog)
	//{{AFX_MSG_MAP(CFilePlayerDlg)
	ON_WM_SYSCOMMAND()
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	ON_WM_DESTROY()
	ON_BN_CLICKED(IDC_BUTTON_OPEN, OnButtonOpen)
	ON_BN_CLICKED(IDC_BUTTON_PLAY, OnButtonPlay)
	ON_BN_CLICKED(IDC_BUTTON_PAUSE, OnButtonPause)
	ON_BN_CLICKED(IDC_BUTTON_STOP, OnButtonStop)
	ON_BN_CLICKED(IDC_BUTTON_SPEED_PLUS, OnButtonSpeedPlus)
	ON_BN_CLICKED(IDC_BUTTON_SPEED_MINUS, OnButtonSpeedMinus)
	ON_WM_TIMER()
	ON_BN_CLICKED(IDC_BUTTON_ANALYSIS, OnButtonAnalysis)
	ON_BN_CLICKED(IDC_BUTTON_SNAPSHOT, OnButtonSnapshot)
	//}}AFX_MSG_MAP
	ON_NOTIFY(NM_RELEASEDCAPTURE, IDC_SLIDER_AUDIO_VOLUME, &CFilePlayerDlg::OnReleasedcaptureSliderAudioVolume)
	ON_BN_CLICKED(IDC_BUTTON_SAVE, &CFilePlayerDlg::OnBnClickedButtonSave)
	ON_STN_CLICKED(IDC_STATIC_FRAME1, &CFilePlayerDlg::OnClickedStaticFrame1)
	ON_STN_CLICKED(IDC_STATIC_FRAME2, &CFilePlayerDlg::OnClickedStaticFrame2)
	ON_STN_CLICKED(IDC_STATIC_FRAME3, &CFilePlayerDlg::OnClickedStaticFrame3)
	ON_STN_CLICKED(IDC_STATIC_FRAME4, &CFilePlayerDlg::OnClickedStaticFrame4)
	ON_STN_CLICKED(IDC_STATIC_FRAME5, &CFilePlayerDlg::OnClickedStaticFrame5)
	ON_STN_CLICKED(IDC_STATIC_FRAME6, &CFilePlayerDlg::OnClickedStaticFrame6)
	ON_STN_CLICKED(IDC_STATIC_FRAME7, &CFilePlayerDlg::OnClickedStaticFrame7)
	ON_STN_CLICKED(IDC_STATIC_FRAME8, &CFilePlayerDlg::OnClickedStaticFrame8)
	ON_STN_CLICKED(IDC_STATIC_FRAME9, &CFilePlayerDlg::OnClickedStaticFrame9)
	ON_STN_CLICKED(IDC_STATIC_FRAME10, &CFilePlayerDlg::OnClickedStaticFrame10)
	ON_STN_CLICKED(IDC_STATIC_FRAME11, &CFilePlayerDlg::OnClickedStaticFrame11)
	ON_STN_CLICKED(IDC_STATIC_FRAME12, &CFilePlayerDlg::OnClickedStaticFrame12)
	ON_STN_CLICKED(IDC_STATIC_FRAME13, &CFilePlayerDlg::OnClickedStaticFrame13)
	ON_STN_CLICKED(IDC_STATIC_FRAME14, &CFilePlayerDlg::OnClickedStaticFrame14)
	ON_STN_CLICKED(IDC_STATIC_FRAME15, &CFilePlayerDlg::OnClickedStaticFrame15)
	ON_STN_CLICKED(IDC_STATIC_FRAME16, &CFilePlayerDlg::OnClickedStaticFrame16)
	ON_BN_CLICKED(IDC_BUTTON_SPEED_MINUS2, &CFilePlayerDlg::OnBnClickedButtonSpeedMinus2)
	ON_BN_CLICKED(IDC_BUTTON_SPEED_PLUS2, &CFilePlayerDlg::OnBnClickedButtonSpeedPlus2)
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////

// CFilePlayerDlg message handlers

extern CFilePlayerApp theApp;

QRETURN on_video_decoder_file_callback( PVOID pFile, UINT iFrameNum, double dSampleTime, BYTE * pFrameBuffer, ULONG nFrameBufferLen, PVOID pUserData )
{
//	SC_DEBUG( "on_video_decoder_file_callback( %f, %d )", dSampleTime, nFrameBufferLen );

	return QCAP_RT_OK;
}

double g_d_audio_volume_db_left = 0;

double g_d_audio_volume_db_right = 0;

QRETURN on_audio_decoder_file_callback( PVOID pFile, UINT iFrameNum, double dSampleTime, BYTE * pFrameBuffer, ULONG nFrameBufferLen, PVOID pUserData )
{
	CFilePlayerDlg * pFilePlayerDlg = (CFilePlayerDlg *)(pUserData);

//	SC_DEBUG( "on_audio_decoder_file_callback( %f, %d )", dSampleTime, nFrameBufferLen );

	if( pFilePlayerDlg->m_nAudioBitsPerSample == 16 && 
		
		pFilePlayerDlg->m_nAudioChannels == 2 ) {

		double  L = 0;

		double  R = 0;

		SHORT * po = (SHORT *)(pFrameBuffer);

		ULONG   samples = nFrameBufferLen / 4; // 16BITS L + R

		for( ULONG i = 0 ; i < samples ; i++ ) {

			L += abs(*po++);

			R += abs(*po++);
		}
		L /= samples;

		R /= samples;

		double DB_L = 20 * log10( L / 32768.0 );

		double DB_R = 20 * log10( R / 32768.0 );

		g_d_audio_volume_db_left = DB_L;

		g_d_audio_volume_db_right = DB_R;
	}
	return QCAP_RT_OK;
}

QRETURN on_snapshot_done_callback( PVOID pFile, CHAR * pszFilePathName, PVOID pUserData )
{
	SC_DEBUG( "on_snapshot_done_callback( %s )", pszFilePathName );

	return QCAP_RT_OK;
}

BOOL CFilePlayerDlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	// Add "About..." menu item to system menu.

	// IDM_ABOUTBOX must be in the system command range.
	ASSERT((IDM_ABOUTBOX & 0xFFF0) == IDM_ABOUTBOX);
	ASSERT(IDM_ABOUTBOX < 0xF000);

	CMenu* pSysMenu = GetSystemMenu(FALSE);
	if (pSysMenu != NULL)
	{
		CString strAboutMenu;
		strAboutMenu.LoadString(IDS_ABOUTBOX);
		if (!strAboutMenu.IsEmpty())
		{
			pSysMenu->AppendMenu(MF_SEPARATOR);
			pSysMenu->AppendMenu(MF_STRING, IDM_ABOUTBOX, strAboutMenu);
		}
	}

	// Set the icon for this dialog.  The framework does this automatically
	//  when the application's main window is not a dialog
	SetIcon(m_hIcon, TRUE);			// Set big icon
	SetIcon(m_hIcon, FALSE);		// Set small icon
	
	// TODO: Add extra initialization here
	
	// INITIALIZE COM LIBRARY
	// 
	HRESULT hr = CoInitialize( NULL );

//	m_editFilePath.SetWindowText( theApp.GetProfileString( "DEFAULT", "FILE.PATH", "" ) );	

	m_editFilePath.SetWindowText( "" );	

	m_Audio_Volume.SetRange( 0, 100, TRUE );

	m_Audio_Volume.SetPos( 100 );

	m_pFile = NULL;

	m_nVideoFormat = 0;

	m_nVideoWidth = 0;

	m_nVideoHeight = 0;

	m_dVideoFrameRate = 0.0;

	m_nAudioFormat = 0;

	m_nAudioChannels = 0;

	m_nAudioBitsPerSample = 0;

	m_nAudioSampleFrequency = 0;

	m_dFileTotalDuationTimes = 0;

	m_nFileTotalVideoFrames = 0;

	m_nFileTotalAudioFrames = 0;

	m_nFileTotalMetadataFrames = 0;

	m_pDevice = NULL;

	m_StartGetFrame = 0;

	b_StartRecord = FALSE;

	pBoundaryWidth = 0;

	pBoundaryHeight = 0;

	for( ULONG i = 0 ; i < 65536 ; i++)
	{
		b_Delete[i] = FALSE;
	}

	for( ULONG i = 0 ; i < 16 ; i++)
	{
		pStreamBuffer_ShareRecord[i] = NULL;

		nStreamBufferLen_ShareRecord[i] = 0 ;
	}
		
	GetDlgItem( IDC_BUTTON_SAVE )->EnableWindow( FALSE );


	return TRUE;  // return TRUE  unless you set the focus to a control
}

void CFilePlayerDlg::OnDestroy() 
{
	CDialog::OnDestroy();
	
	// TODO: Add your message handler code here
	for( ULONG i = 0 ; i < 16 ; i++)
	{
		QCAP_STOP_SHARE_RECORD(i);

		if( pStreamBuffer_ShareRecord[i] != NULL )
		{
			free(pStreamBuffer_ShareRecord[i]);

			pStreamBuffer_ShareRecord[i] = NULL;

			nStreamBufferLen_ShareRecord[i] = 0 ;
		}
	}
	
	if( m_pFile ) {

		QCAP_DESTROY_FILE( m_pFile );

		m_pFile = NULL;
	}
	CString strFilePath;

	m_editFilePath.GetWindowText( strFilePath );

	m_progTimeBar.SetRange( 0, 200 );

//	theApp.WriteProfileString( "DEFAULT", "FILE.PATH", (LPCTSTR)(strFilePath) );

	QCAP_DESTROY( m_pDevice );

	// UNINITIALIZE COM LIBRARY
	// 
	CoUninitialize();
}

void CFilePlayerDlg::OnSysCommand(UINT nID, LPARAM lParam)
{
	if ((nID & 0xFFF0) == IDM_ABOUTBOX)
	{
		CAboutDlg dlgAbout;
		dlgAbout.DoModal();
	}
	else
	{
		CDialog::OnSysCommand(nID, lParam);
	}
}

// If you add a minimize button to your dialog, you will need the code below
//  to draw the icon.  For MFC applications using the document/view model,
//  this is automatically done for you by the framework.

void CFilePlayerDlg::OnPaint() 
{
	if (IsIconic())
	{
		CPaintDC dc(this); // device context for painting

		SendMessage(WM_ICONERASEBKGND, (WPARAM) dc.GetSafeHdc(), 0);

		// Center icon in client rectangle
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// Draw the icon
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialog::OnPaint();
	}
}

// The system calls this to obtain the cursor to display while the user drags
//  the minimized window.
HCURSOR CFilePlayerDlg::OnQueryDragIcon()
{
	return (HCURSOR) m_hIcon;
}

void CFilePlayerDlg::OnCancel() 
{
	// TODO: Add extra cleanup here
	
	CDialog::OnCancel();
}

void CFilePlayerDlg::OnOK() 
{
	// TODO: Add extra validation here
	
//	CDialog::OnOK();
}


void CFilePlayerDlg::OnButtonOpen() 
{
	// TODO: Add your control notification handler code here
	
	// TODO: Add your control notification handler code here

	//create 

	if(m_pDevice == NULL)
	{
		QCAP_CREATE( "SA7160 PCI", 0, NULL, &m_pDevice );
	}

	// SELECT THE ACTION SCRIPT FILE
	//
	OPENFILENAME ofn;

	CHAR psz[ MAX_PATH ];

	ZeroMemory( &ofn, sizeof(ofn) );

	ofn.lStructSize = sizeof(ofn);

	ofn.hwndOwner = m_hWnd;

	ofn.lpstrFile = psz;

	ofn.lpstrFile[ 0 ] = '\0';

	ofn.nMaxFile = sizeof(psz);

	ofn.lpstrFilter = "AVI, ASF, FLV, MP4, TS, WMV\0*.AVI;*.ASF;*.FLV;*.MP4;*.TS;*.WMV\0";

	ofn.nFilterIndex = 1;

	ofn.lpstrFileTitle = NULL;

	ofn.nMaxFileTitle = 0;

	ofn.lpstrInitialDir = NULL;

	ofn.Flags = OFN_PATHMUSTEXIST | OFN_FILEMUSTEXIST;

	GetOpenFileName( &ofn );

	if( strlen( psz ) > 0 ) {

		m_strFilePath = psz;

		if( m_pFile ) {

			if(b_StartRecord == TRUE)
			{
				b_StartRecord = FALSE;

				m_StartGetFrame = 0;

				for( ULONG i = 0 ; i < 16 ; i++)
				{
					QCAP_STOP_SHARE_RECORD(i);

					if( pStreamBuffer_ShareRecord[i] != NULL )
					{
						free(pStreamBuffer_ShareRecord[i]);

						pStreamBuffer_ShareRecord[i] = NULL;

						nStreamBufferLen_ShareRecord[i] = 0 ;
					}
				}
			}

			QCAP_DESTROY_FILE( m_pFile );

			m_pFile = NULL;
		}
		QCAP_OPEN_FILE_EX( psz, &m_pFile, QCAP_DECODER_TYPE_SOFTWARE, &m_nVideoFormat, &m_nVideoWidth, &m_nVideoHeight, &m_dVideoFrameRate, &m_nAudioFormat, &m_nAudioChannels, &m_nAudioBitsPerSample, &m_nAudioSampleFrequency, &m_dFileTotalDuationTimes, &m_nFileTotalVideoFrames, &m_nFileTotalAudioFrames, &m_nFileTotalMetadataFrames, m_statWindow.m_hWnd, 1 );

		ShowFrame();

		QCAP_REGISTER_VIDEO_DECODER_FILE_CALLBACK_EX( m_pFile, on_video_decoder_file_callback, this );

		QCAP_REGISTER_AUDIO_DECODER_FILE_CALLBACK_EX( m_pFile, on_audio_decoder_file_callback, this );

		QCAP_REGISTER_FILE_SNAPSHOT_DONE_CALLBACK( m_pFile, on_snapshot_done_callback, this );

		QCAP_PAUSE_FILE( m_pFile );

		QCAP_SET_AUDIO_FILE_VOLUME( m_pFile, 100);

		double speed = 0;

		QCAP_GET_FILE_PLAYBACK_SPEED( m_pFile, &speed );

		CHAR psz_info[ 512 ];

		CString vfmt;

		CString afmt;

		if( m_nVideoFormat == QCAP_ENCODER_FORMAT_H264 ) { vfmt = "H264"; }

		if( m_nAudioFormat == QCAP_ENCODER_FORMAT_PCM ) { afmt = "PCM"; }

		if( m_nAudioFormat == QCAP_ENCODER_FORMAT_AAC_RAW ) { afmt = "AAC RAW"; }

		if( m_nAudioFormat == QCAP_ENCODER_FORMAT_AAC_ADTS ) { afmt = "AAC ADTS"; }

		sprintf( psz_info, "File Path = %s\r\nFile Total Duration Times = %f sec\r\nFile Total Video Frames = %d\r\nFile Total Audio Frames = %d\r\nVideo Encoder Format = %s\r\nVideo Width = %d\r\nVideo Height = %d\r\nVideo Frame Rate = %f fps\r\nAudio Encoder Format = %s\r\nAudio Channels = %d\r\nAudio Bits Per Sample = %d bits\r\nAudio Sample Frequency = %d Hz\r\nPlayback Speed = %f", m_strFilePath, m_dFileTotalDuationTimes, m_nFileTotalVideoFrames, m_nFileTotalAudioFrames, vfmt, m_nVideoWidth, m_nVideoHeight, m_dVideoFrameRate, afmt, m_nAudioChannels, m_nAudioBitsPerSample, m_nAudioSampleFrequency, speed );

		m_editFilePath.SetWindowText( psz_info );

		SetTimer( 0x00000000,  10, NULL );

		SetTimer( 0x00000001, 100, NULL );

		GetDlgItem( IDC_BUTTON_SAVE )->EnableWindow( TRUE );
	}
	else {

		return ;
	}
}

void CFilePlayerDlg::OnButtonPlay() 
{
	// TODO: Add your control notification handler code here

	double dSampleTime = 0;

	QCAP_GET_FILE_POSITION_EX( m_pFile, &dSampleTime, QCAP_FILE_TIMEUNIT_FRAME );

	if( dSampleTime >= m_nFileTotalVideoFrames ) {

		QCAP_STOP_FILE( m_pFile );
	}
	QCAP_PLAY_FILE( m_pFile );
}

void CFilePlayerDlg::OnButtonPause() 
{
	// TODO: Add your control notification handler code here

	if(m_pFile)
	{
		QCAP_PAUSE_FILE( m_pFile );

		double dSampleTime = 0;

		QCAP_GET_FILE_POSITION_EX( m_pFile, &dSampleTime, QCAP_FILE_TIMEUNIT_FRAME );

		m_StartGetFrame = dSampleTime;

		ShowFrame();
	}
}

void CFilePlayerDlg::OnButtonStop() 
{
	// TODO: Add your control notification handler code here

	QCAP_STOP_FILE( m_pFile );

	double dSampleTime = 0;

	QCAP_GET_FILE_POSITION_EX( m_pFile, &dSampleTime, QCAP_FILE_TIMEUNIT_FRAME );

	m_StartGetFrame = dSampleTime;

	ShowFrame();
}

void CFilePlayerDlg::OnButtonSpeedPlus() 
{
	if(m_pFile)
	{
		double dSampleTime = 0;

		QCAP_GET_FILE_POSITION_EX( m_pFile, &dSampleTime, QCAP_FILE_TIMEUNIT_FRAME );

		if( (dSampleTime+16) < m_nFileTotalVideoFrames)
		{
			QCAP_SET_FILE_POSITION_EX( m_pFile, dSampleTime+16, QCAP_FILE_TIMEUNIT_FRAME );

			m_StartGetFrame = dSampleTime+16;

			ShowFrame();

			//SC_DEBUG("dSampleTime = %f",dSampleTime);
		}
	}
}

void CFilePlayerDlg::OnButtonSpeedMinus() 
{
	// TODO: Add your control notification handler code here
	
	if(m_pFile)
	{
		double dSampleTime = 0;

		QCAP_GET_FILE_POSITION_EX( m_pFile, &dSampleTime, QCAP_FILE_TIMEUNIT_FRAME );
		
		if(dSampleTime - 16 < 0)
		{
			QCAP_SET_FILE_POSITION_EX( m_pFile, 0, QCAP_FILE_TIMEUNIT_FRAME );

			m_StartGetFrame = 0;

			ShowFrame();
		}
		else
		{
			QCAP_SET_FILE_POSITION_EX( m_pFile, dSampleTime-16, QCAP_FILE_TIMEUNIT_FRAME );

			m_StartGetFrame = dSampleTime-16;

			ShowFrame();
		}
	}

}

void CFilePlayerDlg::OnTimer(UINT_PTR nIDEvent) 
{
	// TODO: Add your message handler code here and/or call default
	
	if( nIDEvent == 0x00000000 ) {

		if( m_pFile ) {

			double dSampleTime = 0;

			QCAP_GET_FILE_POSITION_EX( m_pFile, &dSampleTime, QCAP_FILE_TIMEUNIT_FRAME );

			m_progTimeBar.SetPos( (int)(100.0 * (dSampleTime / m_nFileTotalVideoFrames)) );
		}
	}
	if( nIDEvent == 0x00000001 ) {

		if( m_pFile ) {

			int L = (int)(100.0 +  g_d_audio_volume_db_left); if( L < 0 ) { L = 0; }

			int R = (int)(100.0 + g_d_audio_volume_db_right); if( R < 0 ) { R = 0; }

			m_progAudioVolumeDBBar_L.SetPos( L );

			m_progAudioVolumeDBBar_R.SetPos( R );
		}
	}
	CDialog::OnTimer(nIDEvent);
}

void CFilePlayerDlg::OnButtonAnalysis() 
{
	// TODO: Add your control notification handler code here

	CString str_path;

	CHAR psz_info[ 512 ];

	CString vfmt;

	CString afmt;

	if( m_nVideoFormat == QCAP_ENCODER_FORMAT_H264 ) { vfmt = "H264"; }

	if( m_nAudioFormat == QCAP_ENCODER_FORMAT_PCM ) { afmt = "PCM"; }

	if( m_nAudioFormat == QCAP_ENCODER_FORMAT_AAC_RAW ) { afmt = "AAC RAW"; }

	if( m_nAudioFormat == QCAP_ENCODER_FORMAT_AAC_ADTS ) { afmt = "AAC ADTS"; }

	sprintf( psz_info, "File Path = %s\r\nFile Total Duration Times = %f sec\r\nFile Total Video Frames = %d\r\nFile Total Audio Frames = %d\r\nVideo Encoder Format = %s\r\nVideo Width = %d\r\nVideo Height = %d\r\nVideo Frame Rate = %f fps\r\nAudio Encoder Format = %s\r\nAudio Channels = %d\r\nAudio Bits Per Sample = %d bits\r\nAudio Sample Frequency = %d Hz\r\n", m_strFilePath, m_dFileTotalDuationTimes, m_nFileTotalVideoFrames, m_nFileTotalAudioFrames, vfmt, m_nVideoWidth, m_nVideoHeight, m_dVideoFrameRate, afmt, m_nAudioChannels, m_nAudioBitsPerSample, m_nAudioSampleFrequency );

	{	CHAR psz[ MAX_PATH ];

		GetModuleFileName( NULL, psz, MAX_PATH );

		str_path = psz;

		str_path = str_path.Left( str_path.ReverseFind('\\') + 1 );

		str_path += "ANALYSIS.LOG";
	}
	ofstream file;

	file.open( str_path );

	file << psz_info;
	
	ULONG  nStreamBufferSize = m_nVideoWidth * m_nVideoHeight * 3 / 2;

	BYTE * pStreamBuffer = (BYTE *)(malloc( nStreamBufferSize ));

	double dLastSampleTime = 0;

	file << "\r\n[VIDEO STREAM]\r\n\r\n";

	for( ULONG i = 0 ; i < m_nFileTotalVideoFrames ; i++ ) {

		ULONG  nStreamBufferLen = nStreamBufferSize;

		BOOL   bIsKeyFrame = FALSE;

		double dSampleTime = 0;

		QCAP_GET_VIDEO_FILE_STREAM_BUFFER( m_pFile, i, pStreamBuffer, &nStreamBufferLen, &bIsKeyFrame, &dSampleTime );

		sprintf( psz_info, "%08d %f (%f) - %d BYTES\t[%02X%02X%02X%02X%02X%02X%02X%02X %02X%02X%02X%02X%02X%02X%02X%02X] %s\r\n", i, dSampleTime, dSampleTime - dLastSampleTime, nStreamBufferLen, pStreamBuffer[ 0 ], pStreamBuffer[ 1 ], pStreamBuffer[ 2 ], pStreamBuffer[ 3 ], pStreamBuffer[ 4 ], pStreamBuffer[ 5 ], pStreamBuffer[ 6 ], pStreamBuffer[ 7 ], pStreamBuffer[ 8 ], pStreamBuffer[ 9 ], pStreamBuffer[ 10 ], pStreamBuffer[ 11 ], pStreamBuffer[ 12 ], pStreamBuffer[ 13 ], pStreamBuffer[ 14 ], pStreamBuffer[ 15 ], bIsKeyFrame ? "[I]" : "" );

		file << psz_info;

		dLastSampleTime = dSampleTime;
	}

	file << "\r\n[AUDIO STREAM]\r\n\r\n";

	dLastSampleTime = 0;

	for( i = 0 ; i < m_nFileTotalAudioFrames ; i++ ) {

		ULONG  nStreamBufferLen = nStreamBufferSize;

		double dSampleTime = 0;

		QCAP_GET_AUDIO_FILE_STREAM_BUFFER( m_pFile, i, pStreamBuffer, &nStreamBufferLen, &dSampleTime );

		sprintf( psz_info, "%08d %f (%f) - %d BYTES\t[%02X%02X%02X%02X%02X%02X%02X%02X %02X%02X%02X%02X%02X%02X%02X%02X]\r\n", i, dSampleTime, dSampleTime - dLastSampleTime, nStreamBufferLen, pStreamBuffer[ 0 ], pStreamBuffer[ 1 ], pStreamBuffer[ 2 ], pStreamBuffer[ 3 ], pStreamBuffer[ 4 ], pStreamBuffer[ 5 ], pStreamBuffer[ 6 ], pStreamBuffer[ 7 ], pStreamBuffer[ 8 ], pStreamBuffer[ 9 ], pStreamBuffer[ 10 ], pStreamBuffer[ 11 ], pStreamBuffer[ 12 ], pStreamBuffer[ 13 ], pStreamBuffer[ 14 ], pStreamBuffer[ 15 ] );

		file << psz_info;

		dLastSampleTime = dSampleTime;
	}
	file.close();

	if( pStreamBuffer ) {

		free( pStreamBuffer );

		pStreamBuffer = NULL;
	}

#if 0 // TEST ONLY FOR EXPORT & MERGE

	QCAP_EXPORT_FILE( m_pFile, 0, m_dFileTotalDuationTimes / 2, "D:\\FRONT.2.MP4" );

	QCAP_EXPORT_FILE( m_pFile, m_dFileTotalDuationTimes / 2, m_dFileTotalDuationTimes, "D:\\BACK.2.MP4" );

	QCAP_MERGE_FILES( "D:\\FRONT.2.MP4", "D:\\BACK.2.MP4", "D:\\MERGE.2.MP4" );

#endif

	AfxMessageBox( "PLEASE CHECK ANALYSIS.LOG" ); 
}

void CFilePlayerDlg::OnButtonSnapshot() 
{
	// TODO: Add your control notification handler code here

	QCAP_SNAPSHOT_FILE_BMP( m_pFile, "TEST.BMP"  );

//	QCAP_SNAPSHOT_FILE_JPG( m_pFile, "TEST.JPG", 100 );	
}


void CFilePlayerDlg::OnReleasedcaptureSliderAudioVolume(NMHDR *pNMHDR, LRESULT *pResult)
{
	// TODO: Add your control notification handler code here

	QCAP_SET_AUDIO_FILE_VOLUME( m_pFile, m_Audio_Volume.GetPos() );

	*pResult = 0;
}


BOOL CFilePlayerDlg::ShowFrame()
{
	// TODO: Add your control notification handler code here

	if( (m_pFile) && (m_pDevice) )
	{
		//init
		//
		QCAP_SET_OSD_SHARE_RECORD_TEXT( 0, 0, (m_nVideoWidth/2)-(pBoundaryWidth/2), (m_nVideoHeight/2)-(pBoundaryHeight/2), 0, 0, "", "Arial", QCAP_FONT_STYLE_BOLD, 400, 0xFFFF0000, 0x00FFFFFF, 255, 0, 0, 0);

		QCAP_SET_OSD_SHARE_RECORD_TEXT( 1, 0, (m_nVideoWidth/2)-(pBoundaryWidth/2), (m_nVideoHeight/2)-(pBoundaryHeight/2), 0, 0, "", "Arial", QCAP_FONT_STYLE_BOLD, 400, 0xFFFF0000, 0x00FFFFFF, 255, 0, 0, 0);

		QCAP_SET_OSD_SHARE_RECORD_TEXT( 2, 0, (m_nVideoWidth/2)-(pBoundaryWidth/2), (m_nVideoHeight/2)-(pBoundaryHeight/2), 0, 0, "", "Arial", QCAP_FONT_STYLE_BOLD, 400, 0xFFFF0000, 0x00FFFFFF, 255, 0, 0, 0);

		QCAP_SET_OSD_SHARE_RECORD_TEXT( 3, 0, (m_nVideoWidth/2)-(pBoundaryWidth/2), (m_nVideoHeight/2)-(pBoundaryHeight/2), 0, 0, "", "Arial", QCAP_FONT_STYLE_BOLD, 400, 0xFFFF0000, 0x00FFFFFF, 255, 0, 0, 0);

		QCAP_SET_OSD_SHARE_RECORD_TEXT( 4, 0, (m_nVideoWidth/2)-(pBoundaryWidth/2), (m_nVideoHeight/2)-(pBoundaryHeight/2), 0, 0, "", "Arial", QCAP_FONT_STYLE_BOLD, 400, 0xFFFF0000, 0x00FFFFFF, 255, 0, 0, 0);

		QCAP_SET_OSD_SHARE_RECORD_TEXT( 5, 0, (m_nVideoWidth/2)-(pBoundaryWidth/2), (m_nVideoHeight/2)-(pBoundaryHeight/2), 0, 0, "", "Arial", QCAP_FONT_STYLE_BOLD, 400, 0xFFFF0000, 0x00FFFFFF, 255, 0, 0, 0);

		QCAP_SET_OSD_SHARE_RECORD_TEXT( 6, 0, (m_nVideoWidth/2)-(pBoundaryWidth/2), (m_nVideoHeight/2)-(pBoundaryHeight/2), 0, 0, "", "Arial", QCAP_FONT_STYLE_BOLD, 400, 0xFFFF0000, 0x00FFFFFF, 255, 0, 0, 0);

		QCAP_SET_OSD_SHARE_RECORD_TEXT( 7, 0, (m_nVideoWidth/2)-(pBoundaryWidth/2), (m_nVideoHeight/2)-(pBoundaryHeight/2), 0, 0, "", "Arial", QCAP_FONT_STYLE_BOLD, 400, 0xFFFF0000, 0x00FFFFFF, 255, 0, 0, 0);

		QCAP_SET_OSD_SHARE_RECORD_TEXT( 8, 0, (m_nVideoWidth/2)-(pBoundaryWidth/2), (m_nVideoHeight/2)-(pBoundaryHeight/2), 0, 0, "", "Arial", QCAP_FONT_STYLE_BOLD, 400, 0xFFFF0000, 0x00FFFFFF, 255, 0, 0, 0);

		QCAP_SET_OSD_SHARE_RECORD_TEXT( 9, 0, (m_nVideoWidth/2)-(pBoundaryWidth/2), (m_nVideoHeight/2)-(pBoundaryHeight/2), 0, 0, "", "Arial", QCAP_FONT_STYLE_BOLD, 400, 0xFFFF0000, 0x00FFFFFF, 255, 0, 0, 0);

		QCAP_SET_OSD_SHARE_RECORD_TEXT( 10, 0, (m_nVideoWidth/2)-(pBoundaryWidth/2), (m_nVideoHeight/2)-(pBoundaryHeight/2), 0, 0, "", "Arial", QCAP_FONT_STYLE_BOLD, 400, 0xFFFF0000, 0x00FFFFFF, 255, 0, 0, 0);

		QCAP_SET_OSD_SHARE_RECORD_TEXT( 11, 0, (m_nVideoWidth/2)-(pBoundaryWidth/2), (m_nVideoHeight/2)-(pBoundaryHeight/2), 0, 0, "", "Arial", QCAP_FONT_STYLE_BOLD, 400, 0xFFFF0000, 0x00FFFFFF, 255, 0, 0, 0);

		QCAP_SET_OSD_SHARE_RECORD_TEXT( 12, 0, (m_nVideoWidth/2)-(pBoundaryWidth/2), (m_nVideoHeight/2)-(pBoundaryHeight/2), 0, 0, "", "Arial", QCAP_FONT_STYLE_BOLD, 400, 0xFFFF0000, 0x00FFFFFF, 255, 0, 0, 0);

		QCAP_SET_OSD_SHARE_RECORD_TEXT( 13, 0, (m_nVideoWidth/2)-(pBoundaryWidth/2), (m_nVideoHeight/2)-(pBoundaryHeight/2), 0, 0, "", "Arial", QCAP_FONT_STYLE_BOLD, 400, 0xFFFF0000, 0x00FFFFFF, 255, 0, 0, 0);

		QCAP_SET_OSD_SHARE_RECORD_TEXT( 14, 0, (m_nVideoWidth/2)-(pBoundaryWidth/2), (m_nVideoHeight/2)-(pBoundaryHeight/2), 0, 0, "", "Arial", QCAP_FONT_STYLE_BOLD, 400, 0xFFFF0000, 0x00FFFFFF, 255, 0, 0, 0);

		QCAP_SET_OSD_SHARE_RECORD_TEXT( 15, 0, (m_nVideoWidth/2)-(pBoundaryWidth/2), (m_nVideoHeight/2)-(pBoundaryHeight/2), 0, 0, "", "Arial", QCAP_FONT_STYLE_BOLD, 400, 0xFFFF0000, 0x00FFFFFF, 255, 0, 0, 0);

		ULONG  nStreamBufferSize = m_nVideoWidth * m_nVideoHeight * 3 / 2;

		BOOL   bIsKeyFrame = FALSE;

		double dSampleTime[16] = { 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0 };

		for( ULONG i = 0 ; i < 16 ; i++)
		{
			if( pStreamBuffer_ShareRecord[i] != NULL )
			{
				free(pStreamBuffer_ShareRecord[i]);

				pStreamBuffer_ShareRecord[i] = NULL;

				nStreamBufferLen_ShareRecord[i] = 0 ;
			}

			pStreamBuffer_ShareRecord[i] = (BYTE *)(malloc( nStreamBufferSize ));

			nStreamBufferLen_ShareRecord[i] = nStreamBufferSize;

			if( b_StartRecord == FALSE )
			{
				b_StartRecord = TRUE;

				QCAP_SET_VIDEO_SHARE_RECORD_PROPERTY( 0, QCAP_ENCODER_TYPE_SOFTWARE, QCAP_ENCODER_FORMAT_H264, QCAP_COLORSPACE_TYEP_YV12, m_nVideoWidth, m_nVideoHeight, 30, QCAP_RECORD_MODE_CBR, 8000, 12 * 1024 * 1024, 30, 0, 0, m_FrameWindow1.m_hWnd, 1 );

				QCAP_SET_VIDEO_SHARE_RECORD_PROPERTY( 1, QCAP_ENCODER_TYPE_SOFTWARE, QCAP_ENCODER_FORMAT_H264, QCAP_COLORSPACE_TYEP_YV12, m_nVideoWidth, m_nVideoHeight, 30, QCAP_RECORD_MODE_CBR, 8000, 12 * 1024 * 1024, 30, 0, 0, m_FrameWindow2.m_hWnd, 1 );

				QCAP_SET_VIDEO_SHARE_RECORD_PROPERTY( 2, QCAP_ENCODER_TYPE_SOFTWARE, QCAP_ENCODER_FORMAT_H264, QCAP_COLORSPACE_TYEP_YV12, m_nVideoWidth, m_nVideoHeight, 30, QCAP_RECORD_MODE_CBR, 8000, 12 * 1024 * 1024, 30, 0, 0, m_FrameWindow3.m_hWnd, 1 );

				QCAP_SET_VIDEO_SHARE_RECORD_PROPERTY( 3, QCAP_ENCODER_TYPE_SOFTWARE, QCAP_ENCODER_FORMAT_H264, QCAP_COLORSPACE_TYEP_YV12, m_nVideoWidth, m_nVideoHeight, 30, QCAP_RECORD_MODE_CBR, 8000, 12 * 1024 * 1024, 30, 0, 0, m_FrameWindow4.m_hWnd, 1 );

				QCAP_SET_VIDEO_SHARE_RECORD_PROPERTY( 4, QCAP_ENCODER_TYPE_SOFTWARE, QCAP_ENCODER_FORMAT_H264, QCAP_COLORSPACE_TYEP_YV12, m_nVideoWidth, m_nVideoHeight, 30, QCAP_RECORD_MODE_CBR, 8000, 12 * 1024 * 1024, 30, 0, 0, m_FrameWindow5.m_hWnd, 1 );

				QCAP_SET_VIDEO_SHARE_RECORD_PROPERTY( 5, QCAP_ENCODER_TYPE_SOFTWARE, QCAP_ENCODER_FORMAT_H264, QCAP_COLORSPACE_TYEP_YV12, m_nVideoWidth, m_nVideoHeight, 30, QCAP_RECORD_MODE_CBR, 8000, 12 * 1024 * 1024, 30, 0, 0, m_FrameWindow6.m_hWnd, 1 );

				QCAP_SET_VIDEO_SHARE_RECORD_PROPERTY( 6, QCAP_ENCODER_TYPE_SOFTWARE, QCAP_ENCODER_FORMAT_H264, QCAP_COLORSPACE_TYEP_YV12, m_nVideoWidth, m_nVideoHeight, 30, QCAP_RECORD_MODE_CBR, 8000, 12 * 1024 * 1024, 30, 0, 0, m_FrameWindow7.m_hWnd, 1 );

				QCAP_SET_VIDEO_SHARE_RECORD_PROPERTY( 7, QCAP_ENCODER_TYPE_SOFTWARE, QCAP_ENCODER_FORMAT_H264, QCAP_COLORSPACE_TYEP_YV12, m_nVideoWidth, m_nVideoHeight, 30, QCAP_RECORD_MODE_CBR, 8000, 12 * 1024 * 1024, 30, 0, 0, m_FrameWindow8.m_hWnd, 1 );

				QCAP_SET_VIDEO_SHARE_RECORD_PROPERTY( 8, QCAP_ENCODER_TYPE_SOFTWARE, QCAP_ENCODER_FORMAT_H264, QCAP_COLORSPACE_TYEP_YV12, m_nVideoWidth, m_nVideoHeight, 30, QCAP_RECORD_MODE_CBR, 8000, 12 * 1024 * 1024, 30, 0, 0, m_FrameWindow9.m_hWnd, 1 );

				QCAP_SET_VIDEO_SHARE_RECORD_PROPERTY( 9, QCAP_ENCODER_TYPE_SOFTWARE, QCAP_ENCODER_FORMAT_H264, QCAP_COLORSPACE_TYEP_YV12, m_nVideoWidth, m_nVideoHeight, 30, QCAP_RECORD_MODE_CBR, 8000, 12 * 1024 * 1024, 30, 0, 0, m_FrameWindow10.m_hWnd, 1 );

				QCAP_SET_VIDEO_SHARE_RECORD_PROPERTY( 10, QCAP_ENCODER_TYPE_SOFTWARE, QCAP_ENCODER_FORMAT_H264, QCAP_COLORSPACE_TYEP_YV12, m_nVideoWidth, m_nVideoHeight, 30, QCAP_RECORD_MODE_CBR, 8000, 12 * 1024 * 1024, 30, 0, 0, m_FrameWindow11.m_hWnd, 1 );

				QCAP_SET_VIDEO_SHARE_RECORD_PROPERTY( 11, QCAP_ENCODER_TYPE_SOFTWARE, QCAP_ENCODER_FORMAT_H264, QCAP_COLORSPACE_TYEP_YV12, m_nVideoWidth, m_nVideoHeight, 30, QCAP_RECORD_MODE_CBR, 8000, 12 * 1024 * 1024, 30, 0, 0, m_FrameWindow12.m_hWnd, 1 );

				QCAP_SET_VIDEO_SHARE_RECORD_PROPERTY( 12, QCAP_ENCODER_TYPE_SOFTWARE, QCAP_ENCODER_FORMAT_H264, QCAP_COLORSPACE_TYEP_YV12, m_nVideoWidth, m_nVideoHeight, 30, QCAP_RECORD_MODE_CBR, 8000, 12 * 1024 * 1024, 30, 0, 0, m_FrameWindow13.m_hWnd, 1 );

				QCAP_SET_VIDEO_SHARE_RECORD_PROPERTY( 13, QCAP_ENCODER_TYPE_SOFTWARE, QCAP_ENCODER_FORMAT_H264, QCAP_COLORSPACE_TYEP_YV12, m_nVideoWidth, m_nVideoHeight, 30, QCAP_RECORD_MODE_CBR, 8000, 12 * 1024 * 1024, 30, 0, 0, m_FrameWindow14.m_hWnd, 1 );

				QCAP_SET_VIDEO_SHARE_RECORD_PROPERTY( 14, QCAP_ENCODER_TYPE_SOFTWARE, QCAP_ENCODER_FORMAT_H264, QCAP_COLORSPACE_TYEP_YV12, m_nVideoWidth, m_nVideoHeight, 30, QCAP_RECORD_MODE_CBR, 8000, 12 * 1024 * 1024, 30, 0, 0, m_FrameWindow15.m_hWnd, 1 );

				QCAP_SET_VIDEO_SHARE_RECORD_PROPERTY( 15, QCAP_ENCODER_TYPE_SOFTWARE, QCAP_ENCODER_FORMAT_H264, QCAP_COLORSPACE_TYEP_YV12, m_nVideoWidth, m_nVideoHeight, 30, QCAP_RECORD_MODE_CBR, 8000, 12 * 1024 * 1024, 30, 0, 0, m_FrameWindow16.m_hWnd, 1 );

				for( ULONG i = 0 ; i < 16 ; i++ )
				{
					QCAP_SET_AUDIO_SHARE_RECORD_PROPERTY( i, QCAP_ENCODER_TYPE_SOFTWARE, QCAP_ENCODER_FORMAT_PCM, 2, 16, 48000 );

					QCAP_START_SHARE_RECORD( i, "", QCAP_RECORD_FLAG_DECODE | QCAP_RECORD_FLAG_DISPLAY | QCAP_RECORD_FLAG_VIDEO_ONLY);
				}

				pBoundaryWidth = 0;

				pBoundaryHeight = 0;

				QCAP_GET_OSD_SHARE_RECORD_TEXT_BOUNDARY( 0, 0, "X", "Arial", QCAP_FONT_STYLE_BOLD, 400, &pBoundaryWidth, &pBoundaryHeight );
			}

			if( (i + m_StartGetFrame) >= m_nFileTotalVideoFrames )
			{
				BYTE * empty_buf = NULL ;

				empty_buf = (BYTE *)(malloc( m_nVideoWidth*m_nVideoHeight*2 ));

				memset(empty_buf, 0x00, m_nVideoWidth*m_nVideoHeight*2);

				for( ULONG j = i ; j < 16 ; j++ )
				{
					QCAP_SET_VIDEO_SHARE_RECORD_UNCOMPRESSION_BUFFER( j, QCAP_COLORSPACE_TYEP_YUY2, m_nVideoWidth, m_nVideoHeight, empty_buf, m_nVideoWidth*m_nVideoHeight*2);
				}

				free(empty_buf);
				
				return TRUE;
			}

			if( b_Delete[i + m_StartGetFrame] == TRUE )
			{
				QCAP_SET_OSD_SHARE_RECORD_TEXT( i, 0, (m_nVideoWidth/2)-(pBoundaryWidth/2), (m_nVideoHeight/2)-(pBoundaryHeight/2), 0, 0, "X", "Arial", QCAP_FONT_STYLE_BOLD, 400, 0xFFFF0000, 0x00FFFFFF, 255, 0, 0, 0);
			}

			QCAP_GET_VIDEO_FILE_STREAM_BUFFER( m_pFile, i + m_StartGetFrame, pStreamBuffer_ShareRecord[i], &nStreamBufferLen_ShareRecord[i], &bIsKeyFrame, &dSampleTime[i] );

			QCAP_SET_VIDEO_SHARE_RECORD_COMPRESSION_BUFFER( i, pStreamBuffer_ShareRecord[i], nStreamBufferLen_ShareRecord[i], bIsKeyFrame);
		}
	}
	return TRUE;
}

void CFilePlayerDlg::OnBnClickedButtonSave()
{
	// TODO: Add your control notification handler code here

	double dDurationDuration = 1/m_dVideoFrameRate;

	ULONG  nStreamBufferSize = m_nVideoWidth * m_nVideoHeight * 3 / 2;

	BYTE * pStreamBuffer = (BYTE *)(malloc( nStreamBufferSize ));

	double dSampleTime = 0.0;

	double dSampleTime_get = 0.0;

	QCAP_SET_AUDIO_SHARE_RECORD_PROPERTY( 16, QCAP_ENCODER_TYPE_SOFTWARE, QCAP_ENCODER_FORMAT_PCM, 2, 16, 48000 );

	QCAP_SET_VIDEO_SHARE_RECORD_PROPERTY( 16, QCAP_ENCODER_TYPE_SOFTWARE, QCAP_ENCODER_FORMAT_H264, QCAP_COLORSPACE_TYEP_YV12, m_nVideoWidth, m_nVideoHeight, 30, QCAP_RECORD_MODE_CBR, 8000, 12 * 1024 * 1024, 30, 0, 0, NULL, 1 );

	QCAP_START_SHARE_RECORD( 16, "RESAVE.MP4", QCAP_RECORD_FLAG_FULL | QCAP_RECORD_FLAG_VIDEO_ONLY);

	for( ULONG i = 0 ; i < m_nFileTotalVideoFrames ; i++  )
	{
		ULONG  nStreamBufferLen = nStreamBufferSize;

		BOOL   bIsKeyFrame = FALSE;

		if( b_Delete[i] == FALSE)
		{
			QCAP_GET_VIDEO_FILE_STREAM_BUFFER( m_pFile, i, pStreamBuffer, &nStreamBufferLen, &bIsKeyFrame, &dSampleTime_get );

			QCAP_SET_VIDEO_SHARE_RECORD_COMPRESSION_BUFFER( 16, pStreamBuffer, nStreamBufferLen, bIsKeyFrame, dSampleTime + 0.0000001);

			//SC_DEBUG(" dSampleTime = %f",dSampleTime);

			dSampleTime = dSampleTime + dDurationDuration;
		}
	}

	QCAP_STOP_SHARE_RECORD(16);
}


void CFilePlayerDlg::OnClickedStaticFrame1()
{
	// TODO: Add your control notification handler code here
	if( b_StartRecord )
	{
		if( b_Delete[ 0 + m_StartGetFrame ] == FALSE)
		{
			QCAP_SET_OSD_SHARE_RECORD_TEXT( 0, 0, (m_nVideoWidth/2)-(pBoundaryWidth/2), (m_nVideoHeight/2)-(pBoundaryHeight/2), 0, 0, "X", "Arial", QCAP_FONT_STYLE_BOLD, 400, 0xFFFF0000, 0x00FFFFFF, 255, 0, 0, 0);

			QCAP_SET_VIDEO_SHARE_RECORD_COMPRESSION_BUFFER( 0, pStreamBuffer_ShareRecord[0], nStreamBufferLen_ShareRecord[0], 1);

			b_Delete[ 0 + m_StartGetFrame ] = TRUE;
		}
		else
		{
			QCAP_SET_OSD_SHARE_RECORD_TEXT( 0, 0, (m_nVideoWidth/2)-(pBoundaryWidth/2), (m_nVideoHeight/2)-(pBoundaryHeight/2), 0, 0, "", "Arial", QCAP_FONT_STYLE_BOLD, 400, 0xFFFF0000, 0x00FFFFFF, 255, 0, 0, 0);

			QCAP_SET_VIDEO_SHARE_RECORD_COMPRESSION_BUFFER( 0, pStreamBuffer_ShareRecord[0], nStreamBufferLen_ShareRecord[0], 1);

			b_Delete[ 0 + m_StartGetFrame ] = FALSE;
		}
	}
}


void CFilePlayerDlg::OnClickedStaticFrame2()
{
	// TODO: Add your control notification handler code here

	if( b_StartRecord )
	{
		if( b_Delete[ 1 + m_StartGetFrame ] == FALSE)
		{
			QCAP_SET_OSD_SHARE_RECORD_TEXT( 1, 0, (m_nVideoWidth/2)-(pBoundaryWidth/2), (m_nVideoHeight/2)-(pBoundaryHeight/2), 0, 0, "X", "Arial", QCAP_FONT_STYLE_BOLD, 400, 0xFFFF0000, 0x00FFFFFF, 255, 0, 0, 0);

			QCAP_SET_VIDEO_SHARE_RECORD_COMPRESSION_BUFFER( 1, pStreamBuffer_ShareRecord[1], nStreamBufferLen_ShareRecord[1], 1);

			b_Delete[ 1 + m_StartGetFrame ] = TRUE;
		}
		else
		{
			QCAP_SET_OSD_SHARE_RECORD_TEXT( 1, 0, (m_nVideoWidth/2)-(pBoundaryWidth/2), (m_nVideoHeight/2)-(pBoundaryHeight/2), 0, 0, "", "Arial", QCAP_FONT_STYLE_BOLD, 400, 0xFFFF0000, 0x00FFFFFF, 255, 0, 0, 0);

			QCAP_SET_VIDEO_SHARE_RECORD_COMPRESSION_BUFFER( 1, pStreamBuffer_ShareRecord[1], nStreamBufferLen_ShareRecord[1], 1);

			b_Delete[ 1 + m_StartGetFrame ] = FALSE;
		}
	}
}


void CFilePlayerDlg::OnClickedStaticFrame3()
{
	// TODO: Add your control notification handler code here

	if( b_StartRecord )
	{
		if( b_Delete[ 2 + m_StartGetFrame ] == FALSE)
		{
			QCAP_SET_OSD_SHARE_RECORD_TEXT( 2, 0, (m_nVideoWidth/2)-(pBoundaryWidth/2), (m_nVideoHeight/2)-(pBoundaryHeight/2), 0, 0, "X", "Arial", QCAP_FONT_STYLE_BOLD, 400, 0xFFFF0000, 0x00FFFFFF, 255, 0, 0, 0);

			QCAP_SET_VIDEO_SHARE_RECORD_COMPRESSION_BUFFER( 2, pStreamBuffer_ShareRecord[2], nStreamBufferLen_ShareRecord[2], 1);

			b_Delete[ 2 + m_StartGetFrame ] = TRUE;
		}
		else
		{
			QCAP_SET_OSD_SHARE_RECORD_TEXT( 2, 0, (m_nVideoWidth/2)-(pBoundaryWidth/2), (m_nVideoHeight/2)-(pBoundaryHeight/2), 0, 0, "", "Arial", QCAP_FONT_STYLE_BOLD, 400, 0xFFFF0000, 0x00FFFFFF, 255, 0, 0, 0);

			QCAP_SET_VIDEO_SHARE_RECORD_COMPRESSION_BUFFER( 2, pStreamBuffer_ShareRecord[2], nStreamBufferLen_ShareRecord[2], 1);

			b_Delete[ 2 + m_StartGetFrame ] = FALSE;
		}
	}
}


void CFilePlayerDlg::OnClickedStaticFrame4()
{
	// TODO: Add your control notification handler code here

	if( b_StartRecord )
	{
		if( b_Delete[ 3 + m_StartGetFrame ] == FALSE)
		{
			QCAP_SET_OSD_SHARE_RECORD_TEXT( 3, 0, (m_nVideoWidth/2)-(pBoundaryWidth/2), (m_nVideoHeight/2)-(pBoundaryHeight/2), 0, 0, "X", "Arial", QCAP_FONT_STYLE_BOLD, 400, 0xFFFF0000, 0x00FFFFFF, 255, 0, 0, 0);

			QCAP_SET_VIDEO_SHARE_RECORD_COMPRESSION_BUFFER( 3, pStreamBuffer_ShareRecord[3], nStreamBufferLen_ShareRecord[3], 1);

			b_Delete[ 3 + m_StartGetFrame ] = TRUE;
		}
		else
		{
			QCAP_SET_OSD_SHARE_RECORD_TEXT( 3, 0, (m_nVideoWidth/2)-(pBoundaryWidth/2), (m_nVideoHeight/2)-(pBoundaryHeight/2), 0, 0, "", "Arial", QCAP_FONT_STYLE_BOLD, 400, 0xFFFF0000, 0x00FFFFFF, 255, 0, 0, 0);

			QCAP_SET_VIDEO_SHARE_RECORD_COMPRESSION_BUFFER( 3, pStreamBuffer_ShareRecord[3], nStreamBufferLen_ShareRecord[3], 1);

			b_Delete[ 3 + m_StartGetFrame ] = FALSE;
		}
	}
}


void CFilePlayerDlg::OnClickedStaticFrame5()
{
	// TODO: Add your control notification handler code here

	if( b_StartRecord )
	{
		if( b_Delete[ 4 + m_StartGetFrame ] == FALSE)
		{
			QCAP_SET_OSD_SHARE_RECORD_TEXT( 4, 0, (m_nVideoWidth/2)-(pBoundaryWidth/2), (m_nVideoHeight/2)-(pBoundaryHeight/2), 0, 0, "X", "Arial", QCAP_FONT_STYLE_BOLD, 400, 0xFFFF0000, 0x00FFFFFF, 255, 0, 0, 0);

			QCAP_SET_VIDEO_SHARE_RECORD_COMPRESSION_BUFFER( 4, pStreamBuffer_ShareRecord[4], nStreamBufferLen_ShareRecord[4], 1);

			b_Delete[ 4 + m_StartGetFrame ] = TRUE;
		}
		else
		{
			QCAP_SET_OSD_SHARE_RECORD_TEXT( 4, 0, (m_nVideoWidth/2)-(pBoundaryWidth/2), (m_nVideoHeight/2)-(pBoundaryHeight/2), 0, 0, "", "Arial", QCAP_FONT_STYLE_BOLD, 400, 0xFFFF0000, 0x00FFFFFF, 255, 0, 0, 0);

			QCAP_SET_VIDEO_SHARE_RECORD_COMPRESSION_BUFFER( 4, pStreamBuffer_ShareRecord[4], nStreamBufferLen_ShareRecord[4], 1);

			b_Delete[ 4 + m_StartGetFrame ] = FALSE;
		}
	}
}


void CFilePlayerDlg::OnClickedStaticFrame6()
{
	// TODO: Add your control notification handler code here

	if( b_StartRecord )
	{
		if( b_Delete[ 5 + m_StartGetFrame ] == FALSE)
		{
			QCAP_SET_OSD_SHARE_RECORD_TEXT( 5, 0, (m_nVideoWidth/2)-(pBoundaryWidth/2), (m_nVideoHeight/2)-(pBoundaryHeight/2), 0, 0, "X", "Arial", QCAP_FONT_STYLE_BOLD, 400, 0xFFFF0000, 0x00FFFFFF, 255, 0, 0, 0);

			QCAP_SET_VIDEO_SHARE_RECORD_COMPRESSION_BUFFER( 5, pStreamBuffer_ShareRecord[5], nStreamBufferLen_ShareRecord[5], 1);

			b_Delete[ 5 + m_StartGetFrame ] = TRUE;
		}
		else
		{
			QCAP_SET_OSD_SHARE_RECORD_TEXT( 5, 0, (m_nVideoWidth/2)-(pBoundaryWidth/2), (m_nVideoHeight/2)-(pBoundaryHeight/2), 0, 0, "", "Arial", QCAP_FONT_STYLE_BOLD, 400, 0xFFFF0000, 0x00FFFFFF, 255, 0, 0, 0);

			QCAP_SET_VIDEO_SHARE_RECORD_COMPRESSION_BUFFER( 5, pStreamBuffer_ShareRecord[5], nStreamBufferLen_ShareRecord[5], 1);

			b_Delete[ 5 + m_StartGetFrame ] = FALSE;
		}
	}
}


void CFilePlayerDlg::OnClickedStaticFrame7()
{
	// TODO: Add your control notification handler code here

	if( b_StartRecord )
	{
		if( b_Delete[ 6 + m_StartGetFrame ] == FALSE)
		{
			QCAP_SET_OSD_SHARE_RECORD_TEXT( 6, 0, (m_nVideoWidth/2)-(pBoundaryWidth/2), (m_nVideoHeight/2)-(pBoundaryHeight/2), 0, 0, "X", "Arial", QCAP_FONT_STYLE_BOLD, 400, 0xFFFF0000, 0x00FFFFFF, 255, 0, 0, 0);

			QCAP_SET_VIDEO_SHARE_RECORD_COMPRESSION_BUFFER( 6, pStreamBuffer_ShareRecord[6], nStreamBufferLen_ShareRecord[6], 1);

			b_Delete[ 6 + m_StartGetFrame ] = TRUE;
		}
		else
		{
			QCAP_SET_OSD_SHARE_RECORD_TEXT( 6, 0, (m_nVideoWidth/2)-(pBoundaryWidth/2), (m_nVideoHeight/2)-(pBoundaryHeight/2), 0, 0, "", "Arial", QCAP_FONT_STYLE_BOLD, 400, 0xFFFF0000, 0x00FFFFFF, 255, 0, 0, 0);

			QCAP_SET_VIDEO_SHARE_RECORD_COMPRESSION_BUFFER( 6, pStreamBuffer_ShareRecord[6], nStreamBufferLen_ShareRecord[6], 1);

			b_Delete[ 6 + m_StartGetFrame ] = FALSE;
		}
	}
}


void CFilePlayerDlg::OnClickedStaticFrame8()
{
	// TODO: Add your control notification handler code here

	if( b_StartRecord )
	{
		if( b_Delete[ 7 + m_StartGetFrame ] == FALSE)
		{
			QCAP_SET_OSD_SHARE_RECORD_TEXT( 7, 0, (m_nVideoWidth/2)-(pBoundaryWidth/2), (m_nVideoHeight/2)-(pBoundaryHeight/2), 0, 0, "X", "Arial", QCAP_FONT_STYLE_BOLD, 400, 0xFFFF0000, 0x00FFFFFF, 255, 0, 0, 0);

			QCAP_SET_VIDEO_SHARE_RECORD_COMPRESSION_BUFFER( 7, pStreamBuffer_ShareRecord[7], nStreamBufferLen_ShareRecord[7], 1);

			b_Delete[ 7 + m_StartGetFrame ] = TRUE;
		}
		else
		{
			QCAP_SET_OSD_SHARE_RECORD_TEXT( 7, 0, (m_nVideoWidth/2)-(pBoundaryWidth/2), (m_nVideoHeight/2)-(pBoundaryHeight/2), 0, 0, "", "Arial", QCAP_FONT_STYLE_BOLD, 400, 0xFFFF0000, 0x00FFFFFF, 255, 0, 0, 0);

			QCAP_SET_VIDEO_SHARE_RECORD_COMPRESSION_BUFFER( 7, pStreamBuffer_ShareRecord[7], nStreamBufferLen_ShareRecord[7], 1);

			b_Delete[ 7 + m_StartGetFrame ] = FALSE;
		}
	}
}


void CFilePlayerDlg::OnClickedStaticFrame9()
{
	// TODO: Add your control notification handler code here

	if( b_StartRecord )
	{
		if( b_Delete[ 8 + m_StartGetFrame ] == FALSE)
		{
			QCAP_SET_OSD_SHARE_RECORD_TEXT( 8, 0, (m_nVideoWidth/2)-(pBoundaryWidth/2), (m_nVideoHeight/2)-(pBoundaryHeight/2), 0, 0, "X", "Arial", QCAP_FONT_STYLE_BOLD, 400, 0xFFFF0000, 0x00FFFFFF, 255, 0, 0, 0);

			QCAP_SET_VIDEO_SHARE_RECORD_COMPRESSION_BUFFER( 8, pStreamBuffer_ShareRecord[8], nStreamBufferLen_ShareRecord[8], 1);

			b_Delete[ 8 + m_StartGetFrame ] = TRUE;
		}
		else
		{
			QCAP_SET_OSD_SHARE_RECORD_TEXT( 8, 0, (m_nVideoWidth/2)-(pBoundaryWidth/2), (m_nVideoHeight/2)-(pBoundaryHeight/2), 0, 0, "", "Arial", QCAP_FONT_STYLE_BOLD, 400, 0xFFFF0000, 0x00FFFFFF, 255, 0, 0, 0);

			QCAP_SET_VIDEO_SHARE_RECORD_COMPRESSION_BUFFER( 8, pStreamBuffer_ShareRecord[8], nStreamBufferLen_ShareRecord[8], 1);

			b_Delete[ 8 + m_StartGetFrame ] = FALSE;
		}
	}
}


void CFilePlayerDlg::OnClickedStaticFrame10()
{
	// TODO: Add your control notification handler code here

	if( b_StartRecord )
	{
		if( b_Delete[ 9 + m_StartGetFrame ] == FALSE)
		{
			QCAP_SET_OSD_SHARE_RECORD_TEXT( 9, 0, (m_nVideoWidth/2)-(pBoundaryWidth/2), (m_nVideoHeight/2)-(pBoundaryHeight/2), 0, 0, "X", "Arial", QCAP_FONT_STYLE_BOLD, 400, 0xFFFF0000, 0x00FFFFFF, 255, 0, 0, 0);

			QCAP_SET_VIDEO_SHARE_RECORD_COMPRESSION_BUFFER( 9, pStreamBuffer_ShareRecord[9], nStreamBufferLen_ShareRecord[9], 1);

			b_Delete[ 9 + m_StartGetFrame ] = TRUE;
		}
		else
		{
			QCAP_SET_OSD_SHARE_RECORD_TEXT( 9, 0, (m_nVideoWidth/2)-(pBoundaryWidth/2), (m_nVideoHeight/2)-(pBoundaryHeight/2), 0, 0, "", "Arial", QCAP_FONT_STYLE_BOLD, 400, 0xFFFF0000, 0x00FFFFFF, 255, 0, 0, 0);

			QCAP_SET_VIDEO_SHARE_RECORD_COMPRESSION_BUFFER( 9, pStreamBuffer_ShareRecord[9], nStreamBufferLen_ShareRecord[9], 1);

			b_Delete[ 9 + m_StartGetFrame ] = FALSE;
		}
	}
}


void CFilePlayerDlg::OnClickedStaticFrame11()
{
	// TODO: Add your control notification handler code here

	if( b_StartRecord )
	{
		if( b_Delete[ 10 + m_StartGetFrame ] == FALSE)
		{
			QCAP_SET_OSD_SHARE_RECORD_TEXT( 10, 0, (m_nVideoWidth/2)-(pBoundaryWidth/2), (m_nVideoHeight/2)-(pBoundaryHeight/2), 0, 0, "X", "Arial", QCAP_FONT_STYLE_BOLD, 400, 0xFFFF0000, 0x00FFFFFF, 255, 0, 0, 0);

			QCAP_SET_VIDEO_SHARE_RECORD_COMPRESSION_BUFFER( 10, pStreamBuffer_ShareRecord[10], nStreamBufferLen_ShareRecord[10], 1);

			b_Delete[ 10 + m_StartGetFrame ] = TRUE;
		}
		else
		{
			QCAP_SET_OSD_SHARE_RECORD_TEXT( 10, 0, (m_nVideoWidth/2)-(pBoundaryWidth/2), (m_nVideoHeight/2)-(pBoundaryHeight/2), 0, 0, "", "Arial", QCAP_FONT_STYLE_BOLD, 400, 0xFFFF0000, 0x00FFFFFF, 255, 0, 0, 0);

			QCAP_SET_VIDEO_SHARE_RECORD_COMPRESSION_BUFFER( 10, pStreamBuffer_ShareRecord[10], nStreamBufferLen_ShareRecord[10], 1);

			b_Delete[ 10 + m_StartGetFrame ] = FALSE;
		}
	}
}


void CFilePlayerDlg::OnClickedStaticFrame12()
{
	// TODO: Add your control notification handler code here

	if( b_StartRecord )
	{
		if( b_Delete[ 11 + m_StartGetFrame ] == FALSE)
		{
			QCAP_SET_OSD_SHARE_RECORD_TEXT( 11, 0, (m_nVideoWidth/2)-(pBoundaryWidth/2), (m_nVideoHeight/2)-(pBoundaryHeight/2), 0, 0, "X", "Arial", QCAP_FONT_STYLE_BOLD, 400, 0xFFFF0000, 0x00FFFFFF, 255, 0, 0, 0);

			QCAP_SET_VIDEO_SHARE_RECORD_COMPRESSION_BUFFER( 11, pStreamBuffer_ShareRecord[11], nStreamBufferLen_ShareRecord[11], 1);

			b_Delete[ 11 + m_StartGetFrame ] = TRUE;
		}
		else
		{
			QCAP_SET_OSD_SHARE_RECORD_TEXT( 11, 0, (m_nVideoWidth/2)-(pBoundaryWidth/2), (m_nVideoHeight/2)-(pBoundaryHeight/2), 0, 0, "", "Arial", QCAP_FONT_STYLE_BOLD, 400, 0xFFFF0000, 0x00FFFFFF, 255, 0, 0, 0);

			QCAP_SET_VIDEO_SHARE_RECORD_COMPRESSION_BUFFER( 11, pStreamBuffer_ShareRecord[11], nStreamBufferLen_ShareRecord[11], 1);

			b_Delete[ 11 + m_StartGetFrame ] = FALSE;
		}
	}
}


void CFilePlayerDlg::OnClickedStaticFrame13()
{
	// TODO: Add your control notification handler code here

	if( b_StartRecord )
	{
		if( b_Delete[ 12 + m_StartGetFrame ] == FALSE)
		{
			QCAP_SET_OSD_SHARE_RECORD_TEXT( 12, 0, (m_nVideoWidth/2)-(pBoundaryWidth/2), (m_nVideoHeight/2)-(pBoundaryHeight/2), 0, 0, "X", "Arial", QCAP_FONT_STYLE_BOLD, 400, 0xFFFF0000, 0x00FFFFFF, 255, 0, 0, 0);

			QCAP_SET_VIDEO_SHARE_RECORD_COMPRESSION_BUFFER( 12, pStreamBuffer_ShareRecord[12], nStreamBufferLen_ShareRecord[12], 1);

			b_Delete[ 12 + m_StartGetFrame ] = TRUE;
		}
		else
		{
			QCAP_SET_OSD_SHARE_RECORD_TEXT( 12, 0, (m_nVideoWidth/2)-(pBoundaryWidth/2), (m_nVideoHeight/2)-(pBoundaryHeight/2), 0, 0, "", "Arial", QCAP_FONT_STYLE_BOLD, 400, 0xFFFF0000, 0x00FFFFFF, 255, 0, 0, 0);

			QCAP_SET_VIDEO_SHARE_RECORD_COMPRESSION_BUFFER( 12, pStreamBuffer_ShareRecord[12], nStreamBufferLen_ShareRecord[12], 1);

			b_Delete[ 12 + m_StartGetFrame ] = FALSE;
		}
	}
}


void CFilePlayerDlg::OnClickedStaticFrame14()
{
	// TODO: Add your control notification handler code here

	if( b_StartRecord )
	{
		if( b_Delete[ 13 + m_StartGetFrame ] == FALSE)
		{
			QCAP_SET_OSD_SHARE_RECORD_TEXT( 13, 0, (m_nVideoWidth/2)-(pBoundaryWidth/2), (m_nVideoHeight/2)-(pBoundaryHeight/2), 0, 0, "X", "Arial", QCAP_FONT_STYLE_BOLD, 400, 0xFFFF0000, 0x00FFFFFF, 255, 0, 0, 0);

			QCAP_SET_VIDEO_SHARE_RECORD_COMPRESSION_BUFFER( 13, pStreamBuffer_ShareRecord[13], nStreamBufferLen_ShareRecord[13], 1);

			b_Delete[ 13 + m_StartGetFrame ] = TRUE;
		}
		else
		{
			QCAP_SET_OSD_SHARE_RECORD_TEXT( 13, 0, (m_nVideoWidth/2)-(pBoundaryWidth/2), (m_nVideoHeight/2)-(pBoundaryHeight/2), 0, 0, "", "Arial", QCAP_FONT_STYLE_BOLD, 400, 0xFFFF0000, 0x00FFFFFF, 255, 0, 0, 0);

			QCAP_SET_VIDEO_SHARE_RECORD_COMPRESSION_BUFFER( 13, pStreamBuffer_ShareRecord[13], nStreamBufferLen_ShareRecord[13], 1);

			b_Delete[ 13 + m_StartGetFrame ] = FALSE;
		}
	}
}


void CFilePlayerDlg::OnClickedStaticFrame15()
{
	// TODO: Add your control notification handler code here

	if( b_StartRecord )
	{
		if( b_Delete[ 14 + m_StartGetFrame ] == FALSE)
		{
			QCAP_SET_OSD_SHARE_RECORD_TEXT( 14, 0, (m_nVideoWidth/2)-(pBoundaryWidth/2), (m_nVideoHeight/2)-(pBoundaryHeight/2), 0, 0, "X", "Arial", QCAP_FONT_STYLE_BOLD, 400, 0xFFFF0000, 0x00FFFFFF, 255, 0, 0, 0);

			QCAP_SET_VIDEO_SHARE_RECORD_COMPRESSION_BUFFER( 14, pStreamBuffer_ShareRecord[14], nStreamBufferLen_ShareRecord[14], 1);

			b_Delete[ 14 + m_StartGetFrame ] = TRUE;
		}
		else
		{
			QCAP_SET_OSD_SHARE_RECORD_TEXT( 14, 0, (m_nVideoWidth/2)-(pBoundaryWidth/2), (m_nVideoHeight/2)-(pBoundaryHeight/2), 0, 0, "", "Arial", QCAP_FONT_STYLE_BOLD, 400, 0xFFFF0000, 0x00FFFFFF, 255, 0, 0, 0);

			QCAP_SET_VIDEO_SHARE_RECORD_COMPRESSION_BUFFER( 14, pStreamBuffer_ShareRecord[14], nStreamBufferLen_ShareRecord[14], 1);

			b_Delete[ 14 + m_StartGetFrame ] = FALSE;
		}
	}
}


void CFilePlayerDlg::OnClickedStaticFrame16()
{
	// TODO: Add your control notification handler code here

	if( b_StartRecord )
	{
		if( b_Delete[ 15 + m_StartGetFrame ] == FALSE)
		{
			QCAP_SET_OSD_SHARE_RECORD_TEXT( 15, 0, (m_nVideoWidth/2)-(pBoundaryWidth/2), (m_nVideoHeight/2)-(pBoundaryHeight/2), 0, 0, "X", "Arial", QCAP_FONT_STYLE_BOLD, 400, 0xFFFF0000, 0x00FFFFFF, 255, 0, 0, 0);

			QCAP_SET_VIDEO_SHARE_RECORD_COMPRESSION_BUFFER( 15, pStreamBuffer_ShareRecord[15], nStreamBufferLen_ShareRecord[15], 1);

			b_Delete[ 15 + m_StartGetFrame ] = TRUE;
		}
		else
		{
			QCAP_SET_OSD_SHARE_RECORD_TEXT( 15, 0, (m_nVideoWidth/2)-(pBoundaryWidth/2), (m_nVideoHeight/2)-(pBoundaryHeight/2), 0, 0, "", "Arial", QCAP_FONT_STYLE_BOLD, 400, 0xFFFF0000, 0x00FFFFFF, 255, 0, 0, 0);

			QCAP_SET_VIDEO_SHARE_RECORD_COMPRESSION_BUFFER( 15, pStreamBuffer_ShareRecord[15], nStreamBufferLen_ShareRecord[15], 1);

			b_Delete[ 15 + m_StartGetFrame ] = FALSE;
		}
	}
}


void CFilePlayerDlg::OnBnClickedButtonSpeedMinus2()
{
	// TODO: Add your control notification handler code here

	if(m_pFile)
	{
		double dSampleTime = 0;

		QCAP_GET_FILE_POSITION_EX( m_pFile, &dSampleTime, QCAP_FILE_TIMEUNIT_FRAME );
		
		if(dSampleTime - 1 < 0)
		{
			QCAP_SET_FILE_POSITION_EX( m_pFile, 0, QCAP_FILE_TIMEUNIT_FRAME );

			m_StartGetFrame = 0;

			ShowFrame();
		}
		else
		{
			QCAP_SET_FILE_POSITION_EX( m_pFile, dSampleTime-1, QCAP_FILE_TIMEUNIT_FRAME );

			m_StartGetFrame = dSampleTime-1;

			ShowFrame();
		}
	}
}


void CFilePlayerDlg::OnBnClickedButtonSpeedPlus2()
{
	// TODO: Add your control notification handler code here

	if(m_pFile)
	{
		double dSampleTime = 0;

		QCAP_GET_FILE_POSITION_EX( m_pFile, &dSampleTime, QCAP_FILE_TIMEUNIT_FRAME );

		if( (dSampleTime+1) < m_nFileTotalVideoFrames)
		{
			QCAP_SET_FILE_POSITION_EX( m_pFile, dSampleTime+1, QCAP_FILE_TIMEUNIT_FRAME );

			m_StartGetFrame = dSampleTime+1;

			ShowFrame();

			//SC_DEBUG("dSampleTime = %f",dSampleTime);
		}
	}
}
